# Allegro Weryfikator Zwrotów

Skrypt do weryfikacji zwrotów Allegro — porównuje zamówienia z Sellasist z rzeczywistymi danymi o zwrotach pobranymi z API Allegro.

---

## Do czego to służy?

Skrypt sprawdza, czy dla każdego zamówienia w Sellasist faktycznie został wykonany zwrot w Allegro, i czy zwrócona kwota zgadza się z wartością zamówienia.

**Przykłady zastosowań:**

- ✅ Weryfikacja listy „Zwroty zrealizowane" — czy wszystko zostało faktycznie zwrócone?
- ✅ Weryfikacja listy „Zwroty oczekujące" — które zamówienia wciąż czekają?
- ✅ Kontrola pracowników — sprawdzenie czy zamówienia zostały prawidłowo przeniesione do odpowiednich statusów
- ✅ Dowolna lista zamówień z Sellasist — skrypt działa na każdym eksporcie, niezależnie od statusu

---

## Wymagania

- **Python 3.10 lub nowszy** — pobierz ze strony [python.org](https://www.python.org/downloads/)
- **Biblioteka requests** — instalacja jednorazowa:

```
pip install requests
```

- **Aplikacja Allegro REST API** — musisz mieć założoną aplikację w panelu Allegro (szczegóły poniżej)

---

## Zakładanie aplikacji w Allegro (jednorazowo)

1. Wejdź na [apps.developer.allegro.pl](https://apps.developer.allegro.pl)
2. Zaloguj się kontem firmowym Allegro
3. Kliknij **„Dodaj aplikację"**
4. Wypełnij:
   - Nazwa: dowolna (np. `Weryfikator zwrotów`)
   - Typ: **aplikacja urządzenia** (device application)
   - Uprawnienia: `allegro:api:orders:read`, `allegro:api:payments:read`
5. Po zapisaniu otrzymasz **Client ID** i **Client Secret** — zapisz je, będą potrzebne przy każdym uruchomieniu

---

## Jak uruchomić?

### Krok 1 — Eksport z Sellasist

1. Wejdź do Sellasist → lista zamówień
2. Przefiltruj zamówienia według potrzeb (np. status „Zwrot zrealizowany")
3. Kliknij **Eksportuj** → pobierz plik CSV
4. Zapisz plik na pulpicie lub w łatwo dostępnym miejscu

### Krok 2 — Uruchomienie skryptu

Otwórz wiersz poleceń (cmd) lub PowerShell, przejdź do folderu ze skryptem i wpisz:

```
python allegro_zwroty.py
```

### Krok 3 — Podaj dane

Skrypt zapyta kolejno o:

1. **Client ID** — skopiuj z panelu aplikacji Allegro
2. **Client Secret** — skopiuj z panelu aplikacji Allegro (nie będzie widoczny podczas wpisywania)
3. **Ścieżkę do pliku CSV** — np. `C:\Users\TwojeImie\Desktop\eksport_zamowien.csv`

### Krok 4 — Autoryzacja w przeglądarce

Po podaniu danych skrypt automatycznie otworzy przeglądarkę z prośbą o zalogowanie się do Allegro. Kliknij „Zezwól" i wróć do okna skryptu — autoryzacja nastąpi automatycznie.

### Krok 5 — Czekaj na wyniki

Skrypt najpierw pobierze wszystkie zwroty z Allegro (może to chwilę potrwać — zależy od liczby zwrotów na koncie), a następnie sprawdzi każde zamówienie z listy. Postęp jest widoczny w oknie konsoli.

---

## Pliki wynikowe

Po zakończeniu w folderze skryptu pojawią się dwa pliki CSV:

| Plik | Zawartość |
|------|-----------|
| `wynik_zwroty_YYYYMMDD_HHMM.csv` | Analiza każdego zamówienia — status zwrotu, kwoty, akcja do podjęcia |
| `wszystkie_zwroty_YYYYMMDD_HHMM.csv` | Pełna lista wszystkich zwrotów pobranych z Allegro |

Otwórz plik wynikowy w Excelu lub LibreOffice Calc (separator kolumn: **średnik**).

---

## Kolumny w pliku wynikowym

| Kolumna | Opis |
|---------|------|
| `sellaasist_id` | Numer zamówienia w Sellasist |
| `order_id` | UUID zamówienia w Allegro |
| `status` | Status (zawsze: ZWROT ZREALIZOWANY) |
| `wartosc_sellasist` | Kwota zamówienia z Sellasist |
| `waluta` | Waluta zamówienia |
| `refunded_total` | Suma zwrotów wykonanych w Allegro |
| `refund_count` | Liczba zwrotów powiązanych z zamówieniem |
| `refund_status` | Status: PEŁNY / CZĘŚCIOWY / BRAK ZWROTU / NADPŁATA |
| `missing_amount` | Różnica między wartością a zwrotem (0.00 = wszystko OK) |
| `refund_datetime` | Data i godzina ostatniego zwrotu |
| `akcja` | Sugerowana czynność do wykonania |

---

## Kolumna AKCJA — legenda

| Wartość | Co oznacza |
|---------|-----------|
| ✅ OK — PRZENIEŚ DO ZREALIZOWANYCH | Zwrot pełny, zgadza się kwota |
| → PRZENIEŚ DO OCZEKUJĄCYCH | Brak zwrotu w Allegro — zamówienie wymaga działania |
| → SPRAWDŹ (brakuje X PLN) | Zwrot częściowy — zwrócono mniej niż wartość zamówienia |
| → SPRAWDŹ (nadpłata X PLN) | Zwrócono więcej niż wartość zamówienia |
| → SPRAWDŹ RĘCZNIE | Błąd API — zamówienie wymaga ręcznej weryfikacji |

---

## Najczęstsze problemy

**Skrypt nie może się połączyć z Allegro**
Sprawdź połączenie internetowe. Upewnij się że nie jest włączony VPN lub proxy blokujące połączenia zewnętrzne.

**Błąd „Brak kolumn w pliku"**
Upewnij się że importujesz plik eksportowany bezpośrednio z Sellasist bez żadnych zmian. Nie otwieraj i nie zapisuj go ponownie w Excelu przed uruchomieniem skryptu.

**Skrypt działa bardzo wolno**
To normalne przy dużych listach zamówień. Dla 1000 zamówień czas to około 5–10 minut. Nie zamykaj okna konsoli.

**Wszystkie zamówienia mają status „BRAK ZWROTU"**
Włącz `DEBUG_FIRST = True` w pliku skryptu (jest tam domyślnie) i sprawdź czy w pliku `wszystkie_zwroty_...csv` są jakiekolwiek zwroty. Jeśli plik jest pusty, sprawdź uprawnienia aplikacji Allegro.

---

## Konfiguracja (dla zaawansowanych)

Na górze pliku `allegro_zwroty.py` znajdują się zmienne konfiguracyjne:

```python
DEBUG_FIRST = True   # wypisuje przykładowy zwrot z API przy pierwszym uruchomieniu
                     # ustaw False gdy wszystko działa poprawnie
```

---

## Kontakt / wsparcie

W razie problemów zgłoś się do osoby odpowiedzialnej za automatyzację procesów w firmie.
